/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.config;

import com.dfdyz.epicacg.config.ClientConfigValue;
import com.dfdyz.epicacg.config.CommonConfig;
import com.dfdyz.epicacg.utils.DeathParticleHandler;
import com.google.common.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jline.utils.InputStreamReader;
import org.slf4j.Logger;

public class ClientConfig {
    public static ClientConfigValue cfg = new ClientConfigValue();
    private static Logger LOGGER = LogUtils.getLogger();

    public static String ReadString(String FileName) {
        String str = "";
        File file = new File(FileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
                return "";
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            str = ClientConfig.readFromFile(FileName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return str;
    }

    public static void Load(boolean isReload) {
        LOGGER.info("EpicAddon:Loading Sword Trail Item");
        LOGGER.info("EpicAddon:Loading Death Particle Modifier");
        String cfgpath = FMLPaths.CONFIGDIR.get().resolve("EpicAddonDeathParticle.json").toString();
        String json = ClientConfig.ReadString(cfgpath);
        if (json != "") {
            DeathParticleHandler.config.clear();
            DeathParticleHandler.config = (DeathParticleHandler.DeathParticleConfig)CommonConfig.GSON.fromJson(json, new TypeToken<DeathParticleHandler.DeathParticleConfig>(){}.getType());
        } else {
            ClientConfig.WriteString(cfgpath, CommonConfig.GSON.toJson((Object)DeathParticleHandler.config));
        }
    }

    public static void SaveClientCfg() {
        String cfgpath = FMLPaths.CONFIGDIR.get().resolve("EpicAddonCommon.json").toString();
        LOGGER.info("EpicAddon:Save Common Config");
        ClientConfig.WriteString(cfgpath, CommonConfig.GSON.toJson((Object)cfg));
    }

    public static void WriteString(String FileName, String str) {
        try (FileOutputStream fos = new FileOutputStream(FileName);
             OutputStreamWriter osw = new OutputStreamWriter(fos);
             BufferedWriter bw = new BufferedWriter(osw);){
            bw.write(str);
            bw.flush();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFromFile(String s) throws IOException {
        FileInputStream inputStream = new FileInputStream(new File(s));
        StringBuilder resultStringBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader((Reader)new InputStreamReader((InputStream)inputStream));){
            String line;
            while ((line = br.readLine()) != null) {
                resultStringBuilder.append(line).append("\n");
            }
        }
        return resultStringBuilder.toString();
    }
}

